/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class StreamTracerThread
implements Runnable {
    private static final String TRACE_MASKD = "XCRTSTTD";
    private static final String TRACE_MASKF = "XCRTSTTF";
    private static final String TRACE_MASKT = "XCRTSTTT";
    private InputStream in = null;
    private boolean doShow = false;
    private PrintStream printStream = null;
    private boolean doTrace = false;
    private String streamName = null;
    private boolean done = false;
    private boolean terminate = false;

    public StreamTracerThread(InputStream in, boolean doShow, PrintStream printStream, boolean doTrace, String streamName) {
        this.in = in;
        this.doShow = doShow;
        this.printStream = printStream;
        this.doTrace = doTrace;
        this.streamName = streamName;
        this.done = false;
        Trace.trace(TRACE_MASKT, "<->StreamTracerThread(" + in + ", " + doShow + ", " + printStream + ", " + doTrace + ", " + streamName + ")");
    }

    public static void main(String[] args) {
    }

    public boolean isDone() {
        return this.done;
    }

    public synchronized void setTerminate() {
        this.terminate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamTracerThread streamTracerThread;
        try {
            int charRead = 0;
            StringBuffer buf = null;
            InputStreamReader reader = null;
            Trace.trace(TRACE_MASKT, "->run()");
            if (this.doTrace) {
                buf = new StringBuffer();
            }
            reader = new InputStreamReader(this.in);
            try {
                while ((charRead = reader.read()) != -1) {
                    if (this.doTrace) {
                        buf.append((char)charRead);
                    }
                    if (this.doShow) {
                        this.printStream.write(charRead);
                    }
                    if (!this.terminate) continue;
                    if (this.doTrace) {
                        Trace.trace(TRACE_MASKF, "terminate requested");
                    }
                    break;
                }
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKD, e);
            }
            if (this.doTrace) {
                Trace.trace(TRACE_MASKF, this.streamName + " = " + buf.toString());
            }
            Trace.trace(TRACE_MASKT, "<-run()");
            Object var6_5 = null;
            streamTracerThread = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            StreamTracerThread streamTracerThread2 = this;
            synchronized (streamTracerThread2) {
                this.done = true;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (streamTracerThread) {
            this.done = true;
            this.notifyAll();
        }
    }
}

